#!/usr/bin/perl -t
use strict;
use warnings;
#use CGI qw/:standard -no_xhtml/;
use CGI qw/:standard/;

my $imagedir="/home/aoe/public_html/images";
my $referer=referer(); # $ENV{HTTP_REFERER};

if ($referer =~ /less_clothing/) {
	$imagedir="/home/aoe/public_html/less_clothing";
}

$ENV{PATH}="/bin:/usr/bin:/usr/local/bin:/home/aoe/bin";

my $erres="";
my ($command,$result, $file, $fileurl, $base, $baseurl, $refererurl, $refererpath);

# set to 1 after successful operation
my $done=0;

# matched on referer
$imagedir =~ m#/([^/]+)$#;
my $imagelast=$1;

if (param("referer")){
	$referer=param("referer");
};

if ($referer) {
	$referer =~ s/#.*//;

	$refererpath=$referer;
	$refererpath =~ m#(.*/)(?:[^/]*.html)$#;
	$refererpath = $1;
	$refererurl = $refererpath;
	$refererpath =~ s#^.*/$imagelast/#/#;

} else {
	print header,title("error"),start_html,p("no referer"),end_html;
	exit(1);
}

	

if (!param("f")) {
	# rehash dir
	if (param("rehash")) {
		chdir "$imagedir/$refererpath";
		$command="exifperm.sh `ls *jpg *jpeg *JPG | grep -vE \"_old|_small|_med\"`; pwd";
		$result=`$command 2>&1`;
		if ($? != 0) {
			$erres="$command\n$result";
		}
		$done=1;
	} else {
		print header,title("error"),start_html,p("file not found"),end_html;
		exit(1);
	}
}


if (($refererpath.param("f")) =~ m#^([\w_/.-]+)$#) {
	$file=$1;
}
$referer .= "#" . param("f");

$fileurl=$refererurl.param("f");

if (param("f")) {
	$file="$imagedir/$1";
	$base=$file;
	$base =~ s/\.[^.]*$//;
	$baseurl=$fileurl;
	$baseurl =~ s/\.[^.]*$//;

	#$file =~ s/^$imagelast/$imagedir/;
	if ($file =~ /[^a-zA-Z0-9_.\/-]/ || $file =~ m#(^|/)\.\.(/|$)#) { 
		print header,title("error"),start_html,p("illegal chars in file"),end_html;
		exit(1);
	}
	if (! -f $file) {
		print header,title("error"),start_html,p("file not found"),end_html;
		exit(1);
	}
	if ($file !~ /\.(jpg|jpeg|JPG)/) {
		print header,title("error"),start_html,p("not an image file"),end_html;
		exit(1);
	}
} elsif (!$done) {
	print header,title("error"),start_html,p("bad file"),end_html;
	exit(1);
}



my $oldc=`rdjpgcom $file`;
#$oldc =~ s/\\([0-3][0-7][0-7])/"&#".oct($1).";"/ge;
$oldc =~ s/\\([0-3][0-7][0-7])/pack("C",oct($1))/ge;
#$oldc =~ s#(http://\S*)#<a href=\"$1\">$1</a>#g;


# comment, file
if (param("c") && param("c") ne $oldc) {
	my $comment;
	param("c") =~ /(.*)/s;
	if (param("c") eq $1) {
		$comment="$1";
		$comment =~ s/\s*$//sg;
		# $comment =~ s/([^\w])/\\$1/g;
		$comment =~ s/(["\$])/\\$1/g;
	} else {
		print header,title("error"),start_html,p("illegal comment"),end_html;
		exit(1);
	}
#print header,title("rotating"),start_html,"\n<pre>\n";
	$file =~ /(.*)(\.[^.]+)$/;
	my $name_old="${1}_old$2";
	my $name_new="${1}_new$2";

	$command="echo -n \"$comment\" | wrjpgcom -replace $file > $name_new";
	$result=`echo -n \"$comment\" | wrjpgcom -replace $file > $name_new`;
	if ($? != 0) {
		$erres.="$command\n$result\n"
	} else {
		rename $file,$name_old;
		rename $name_new,$file;
		# unlink $file_old;
		# update index.html/private
		# update med/sthumb version
		$name_old="${1}_med$2";
		$name_new="${1}_new$2";
		$result=`echo -n \"$comment\" | wrjpgcom -replace $name_old > $name_new`;
		rename $name_new,$name_old;
	}
	$done=1;
		
}

# direction, file
if (defined param("d") && param("d") =~ /^([92])/) {
	my $dir="-$1";
#print header,title("rotating"),start_html,"\n<pre>\n";
	$command="exiftran -i $dir $file";
	$result=`$command 2>&1`;
	if ($? != 0) {
		$erres.="$command\n$result\n"
	}
	if ( -f "${base}_small.jpg") {
		$command="exiftran -i $dir ${base}_small.jpg";
		$result=`$command 2>&1`;
		if ($? != 0) {
			$erres.="$command\n$result\n"
		}
	}
	if ( -f "${base}_med.jpg") {
		$command="exiftran -i $dir ${base}_med.jpg";
		$result=`$command 2>&1`;
		if ($? != 0) {
			$erres.="$command\n$result\n"
		}
	}
	$done=1;
		
}

#print "\n</pre>",p("done"),"<a href=\"$referer\">back</a>",end_html;
if ($done) {
	if ($erres eq "") {
		print redirect($referer);
		exit(0);
	}
	print header,title("error"),start_html,h1("error rotating"),pre(`id`."\n)$erres("),p("<a href=\"$referer\">back</a>"),end_html;
	exit(1);
}
my $head=`cat /home/aoe/public_html/header.html`;
$head =~ s/<!--#.*?-->//msg;
my $foot=`cat /home/aoe/public_html/footer.html`;
$foot =~ s/<!--.*?-->//msg;
#for (keys %ENV) { print "$_ -> $ENV{$_}<br>";}
print header, # title("edit"),
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">
			<html><head><title>aoe: editing $fileurl</title>
			<link rel=\"stylesheet\" href=\"/~aoe/css/images.css\" >
			<META NAME=\"editor\" CONTENT=\"$0\">
			<meta name=\"author\" content=\"alexander\@oelzant.priv.at\">
			<link rel=\"shortcut icon\" href=\"/~aoe/favicon.ico\" >",
			$head,
			h1("editing $fileurl"),
			p("<a href=\"$fileurl\">",
			img({alt=>"$oldc", title=>"$oldc", src=>"${baseurl}_med.jpg"}),
			"</a>"),
			start_form(-method => "GET"),
			p(radio_group(-name=>'d',-values=>['none','270 degrees (left)','90 degrees (right)'])),
			p(textarea(-name => "c", 
						-rows=> 10, 
						-columns=> 80, 
						-default => $oldc)),
			p(hidden(-name => 'referer', -value => "$referer"),
			  hidden(-name => 'f'),
			  submit),
			end_form,
			$foot,
			end_html;


exit(0);
#print header,title("error"),start_html,p("no rotation"),end_html;
