/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */



/*
 * $Id: rpl.h,v 1.11 2000/07/17 10:43:34 root Exp $
 *
 * $Log: rpl.h,v $
 * Revision 1.11  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.10  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.9  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.8  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.7  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.6  1999/09/13 11:04:13  root
 * \#
 *
 * Revision 1.5  1999/09/13 11:04:13  root
 * \#
 *  
 */


typedef unsigned int u32;
typedef unsigned short int u16;
typedef unsigned char u8;


#define LLC_RPL_OVERHEAD 0x30

#define RPL_SAP		0xfc

#define RPL_PK_FIND	0x0001
#define RPL_PK_FOUND	0x0002
#define RPL_PK_SENDFILE	0x0010
#define RPL_PK_FILEDATA	0x0020

#define RPL_IS_TOKEN(a) (a & 0xc000)

#define RPL_TK_TMZ	0x4003
#define RPL_TK_MYMAC	0x4006
#define RPL_TK_SAP	0x4007
#define RPL_TK_FRAMELEN 0x4009
#define RPL_TK_WHOAMI	0x400a
#define RPL_TK_TSZ	0x400b
#define RPL_TK_YOUMAC	0x400c
#define RPL_TK_BLOCK	0x4011
#define RPL_TK_DATA	0x4018
#define RPL_TK_IDENT   	0xc005
#define RPL_TK_ADDR	0xc014

#define RPL_FL_TMZ  	(1L << 0)
#define RPL_FL_MYMAC 	(1L << 1)
#define RPL_FL_SAP 	(1L << 2)
#define RPL_FL_FRAMELEN (1L << 3)
#define RPL_FL_WHOAMI 	(1L << 4)
#define RPL_FL_TSZ 	(1L << 5)
#define RPL_FL_YOUMAC 	(1L << 6)
#define RPL_FL_BLOCK 	(1L << 7)
#define RPL_FL_DATA 	(1L << 8)
#define RPL_FL_IDENT 	(1L << 9)
#define RPL_FL_ADDR 	(1L << 10)

#define RPL_AD_FLAGS_MORE	0x20
#define RPL_AD_FLAGS_DONE	0xc0

#define RPL_FIND_FLAGS (RPL_FL_FRAMELEN|RPL_FL_MYMAC|RPL_FL_IDENT|RPL_FL_TMZ)

#define RPL_FOUND_FLAGS (RPL_FL_TMZ | RPL_FL_TSZ | RPL_FL_YOUMAC | RPL_FL_MYMAC | RPL_FL_FRAMELEN | RPL_FL_WHOAMI | RPL_FL_SAP)

#define RPL_SEND_FILE_FLAGS (RPL_FL_BLOCK | RPL_FL_FRAMELEN | RPL_FL_MYMAC)

#define RPL_FILE_DATA_FLAGS (RPL_FL_BLOCK | RPL_FL_ADDR | RPL_FL_DATA)

struct addr_block
{
  u32 load;
  u32 run;
  u32 flags;
};

#define MAX_DATA_LEN MAX_FRAME_LEN
#define MAX_IDENT_LEN MAX_FRAME_LEN

struct rpl_packet
{
  int flags;

  int type;

  u32 themightyzero;
  u8 mymac[ETH_ALEN];
  u8 sap;
  u16 framelen;
  u16 whoami;
  u16 thesmallzero;
  u8 youmac[ETH_ALEN];
  u32 block;
  u8 data[MAX_DATA_LEN];
  int datalen;

  u8 ident[MAX_IDENT_LEN];
  int identlen;

  struct addr_block addr;
};
