-- test cases for Aufgabe8.hs ($Id: check_Aufgabe9.hs,v 1.3 2004/01/11 09:49:14 fp010 Exp $)
----------------------------------------------------------------------------
-- listFilt :: (a->Bool) -> [[a]] -> [[a]]
listFilt (>3) [[2],[2,4,3,5],[],[34,5]] == [[],[4,5],[],[34,5]]
listFilt (\_->True) [] == ([]::[String])
listFilt (\_->False) [] == ([]::[String])
listFilt (\_->False) [[1..10],[11..20],[42],[]] == [[],[],[],[]]
listFilt (\_->True) [[1..10],[11..20],[42],[]] == [[1..10],[11..20],[42],[]]
-- fOne :: String -> Bool
listFilt fOne [["abc","de"],["XYz"],[],["rTcE","ZBN"]] == [["de"],[],[],["rTcE"]]
fOne ""
not $ fOne "P"
not $ fOne "p"
not $ fOne "Pe"
fOne "pe"
not $ fOne "Pee"
not $ fOne "pee"
fOne "12"
fOne "%%"
fOne "??"
-- fTwo :: Integer -> Bool
listFilt fTwo [[1,2,55,17,3],[24,35],[],[56,13,15,55]] == [[1,2,55,3],[],[],[13,55]]
fTwo 0
-- fThree :: String -> Bool
listFilt fThree [["otto","Otto","P"],[],["lotto"]] == [["otto","P"],[],[]]
fThree ""
----------------------------------------------------------------------------
-- extractSet :: Eq a => [a] -> [a]
null $ extractSet "" 
extractSet [1] == [1]
extractSet "a" == "a"
extractSet "aa" == "a"
extractSet "aaa" == "a"
extractSet "foobardoo" == "fobard" -- we need to retain order of first occurences!
extractSet [-100..100] == [-100..100]
extractSet "abab" == "ab"
-- union :: Eq a => [a] -> [a] -> [a]
null $ ""  `union` ""  
[1] `union` []  == [1]
[]  `union` [2] == [2]
[1] `union` [2] `isEqual` [1,2] -- fails if op-prec has been changed
"a" `union` "a" == "a"
"ab"`union` "a" `isEqual` "ab"
"ab"`union` "b" `isEqual` "ab"
"ab"`union` "ab"`isEqual` "ab"
"ba"`union` "ba"`isEqual` "ab"
"ba"`union` "b" `isEqual` "ab"
"ba"`union` "a" `isEqual` "ab"
"a" `union` "ab"`isEqual` "ab"
"b" `union` "ab"`isEqual` "ab"
"fobar"`union`"dor"`isEqual`"fobard"
[1..100]`union` [2..99] `isEqual` [1..100]
[2..99] `union` [1..100]`isEqual` [1..100]
-- diff :: Eq a => [a] -> [a] -> [a]
null $ "" `diff` ""
null $ "" `diff` "fobar" 
"fobar" `diff` "" `isEqual` "fobar"
"doh" `diff` "ouch" == "d"
"ouch" `diff` "doh" == "uc"
[1..100]`diff` [2..99] `isEqual` [1,100]
null $ [2..99] `diff` [1..100]
-- inters :: Eq a => [a] -> [a] -> [a]
null $ ""  `inters` ""
null $ [1] `inters` []
null $ []  `inters` [2]
null $ [1] `inters` [2]
"a" `inters` "a" == "a"
"ab"`inters` "a" == "a"
"ab"`inters` "b" == "b"
"ab"`inters` "ab"`isEqual` "ab"
"ab"`inters` "ba"`isEqual` "ab"
"ba"`inters` "ba"`isEqual` "ab"
"ba"`inters` "ab"`isEqual` "ab"
"ba"`inters` "b" `isEqual` "b"
"ba"`inters` "a" `isEqual` "a"
"a" `inters` "ab"`isEqual` "a"
"b" `inters` "ab"`isEqual` "b"
"fobar"`inters`"dor"`isEqual`"or"
[1..100]`inters` [2..99] `isEqual` [2..99]
[2..99] `inters` [1..100]`isEqual` [2..99]
-- isSet :: Eq a => [a] -> Bool
isSet ""
isSet "a"
isSet "ab"
not $ isSet "aa"
not $ isSet "aba"
isSet "abc"
isSet [-100..100]
-- isEqual :: Eq a => [a] -> [a] -> Bool
"" `isEqual` ""
not $ "a" `isEqual` ""
not $ "" `isEqual` "a"
"a" `isEqual` "a"
not $ "ab" `isEqual` "a"
not $ "b" `isEqual` "a"
"ab" `isEqual` "ba"
"ab" `isEqual` "ab"
"ba" `isEqual` "ab"
"ba" `isEqual` "ba"
not $ "ab"`isEqual`"bc"
not $ "ba"`isEqual`"bc"
-- isElem :: Eq a => a -> [a] -> Bool
not $ isElem '1' ""
isElem '1' "1"
not $ isElem '1' "2"
isElem '1' "21"
isElem '1' "12"
all (`isElem`[-100..100]) [100..(-100)]
----------------------------------------------------------------------------
-- $Log: check_Aufgabe9.hs,v $
-- Revision 1.3  2004/01/11 09:49:14  fp010
-- added testcases for inters
--
-- Revision 1.2  2004/01/07 13:43:52  fp010
-- provided type context to 2 testcases
--
-- Revision 1.1  2004/01/07 13:41:30  fp010
-- first batch tests
--
