#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/syscall.h>

unsigned long get_sp(void) {
	   __asm__("movl %esp,%eax");
}



/*
 *   print out string with a '--ECHO: ' prefix
 */
void echo(char *s)
{
  char buf[512] = "--ECHO: ";
  strcat(buf, s);
  printf("sp: 0x%p, buf: 0x%p\n", get_sp(),&buf);
  fprintf(stdout, "%s\n", buf);
}

/* 
 *   simple echo service that prints out its first argument
 */
int main(int argc, char **argv)
{
  gid_t r_gid, e_gid;

  /* check arguments */
  if (argc != 2) {
    fprintf(stderr, "please provide one argument to echo\n");
    return 1;
  }


  /* clear environment */ 
  clearenv();
  setenv ("PATH", "/bin:/usr/bin:/usr/local/bin", 1);
  setenv ("IFS", " \t\n", 1); 


  /* temporarily drop privileges */
  e_gid = getegid();
  r_gid = getgid();
  setregid(e_gid, r_gid);


  /* call the echo service */
  echo(argv[1]);

  return 0;
}

